<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * UserPageSpentTime
 *
 * @ORM\Table(name="user_page_spent_time")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\UserPageSpentTimeRepository")
 *
 * @ORM\HasLifecycleCallbacks
 */
class UserPageSpentTime
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="user_id", type="integer")
     */
    private $userId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="create_at", type="datetime")
     */
    private $createAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="end_at", type="datetime")
     */
    private $endAt;

    /**
     * @var integer
     *
     * @ORM\Column(name="second", type="integer")
     */
    private $second = 0;


    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="pageSpentTimes")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;


    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createAt = new \DateTime();
        $this->endAt = new \DateTime();
    }

    /**
     * @ORM\PreUpdate
     */
    public function preUpdate()
    {
//        $DateInterval = $this->endAt->diff($this->createAt);
//
//        $this->second = 0;
//        $this->second += $DateInterval->s;
//        $this->second += $DateInterval->i * 60;
//        $this->second += $DateInterval->h * 60 * 60;
//        $this->second += $DateInterval->d * 60 * 60 * 24;
//        $this->second += $DateInterval->m * 60 * 60 * 24 * 30;
//        $this->second += $DateInterval->y * 60 * 60 * 24 * 30 * 365;

        $this->second = $this->endAt->getTimestamp() - $this->createAt->getTimestamp();
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set userId
     *
     * @param integer $userId
     * @return UserPageSpentTime
     */
    public function setUserId($userId)
    {
        $this->userId = $userId;
    
        return $this;
    }

    /**
     * Get userId
     *
     * @return integer 
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * Set createAt
     *
     * @param \DateTime $createAt
     * @return UserPageSpentTime
     */
    public function setCreateAt($createAt)
    {
        $this->createAt = $createAt;
    
        return $this;
    }

    /**
     * Get createAt
     *
     * @return \DateTime 
     */
    public function getCreateAt()
    {
        return $this->createAt;
    }

    /**
     * Set endAt
     *
     * @param \DateTime $endAt
     * @return UserPageSpentTime
     */
    public function setEndAt($endAt)
    {
        $this->endAt = $endAt;
    
        return $this;
    }

    /**
     * Get endAt
     *
     * @return \DateTime 
     */
    public function getEndAt()
    {
        return $this->endAt;
    }

    /**
     * Set second
     *
     * @param integer $second
     * @return UserPageSpentTime
     */
    public function setSecond($second)
    {
        $this->second = $second;
    
        return $this;
    }

    /**
     * Get second
     *
     * @return integer 
     */
    public function getSecond()
    {
        return $this->second;
    }

    /**
     * Set user
     *
     * @param \VM\ApiBundle\Entity\User $user
     * @return UserPageSpentTime
     */
    public function setUser(\VM\ApiBundle\Entity\User $user = null)
    {
        $this->user = $user;
    
        return $this;
    }

    /**
     * Get user
     *
     * @return \VM\ApiBundle\Entity\User 
     */
    public function getUser()
    {
        return $this->user;
    }
}